/*******************************************************************************
* Device      : AD18F08
* Author      : XAD Application Team
* Version     : V0.0.1
* Date        : 20220919
* Description : 系统外设驱动函数
********************************************************************************/

/********************************INCLUDES*************************************/
#include "Periph.h"
#include "CommDef.h"


void GPIO_Init()
{
/*********************************************************
*	GPIO部分共有以下几个寄存器分别为：
*	
*	TRISA/B/Cn：1-输入状态，port写无效()	默认1
*				0-输出状态
*	PORTA/B/Cn：I/O口数据位（ n=7-0）		默认0
*	PA/B/CPDn : 1-下拉无效 0-下拉有效		默认1
*	PA/B/CPUn : 1-上拉无效 0-上拉有效		默认1		
*	PA/B/CODn : 1-使能开漏 0-普通推挽		默认0
*	PINA/B/C  :	1-读入为1  0-读入IO口为0	 	
*	ANASEL0/1/2 :	1-模拟输出打开关闭	0-模拟输出关闭	默认0
*	SMTVA/B/C	：1-0.3VDD/0.7VDD,0-0.2VDD/0.4VDD 默认1
*
*  以上寄存器既可整体赋值，也可按位赋值；
***********************************************************/	


//需关闭默认的上拉和下拉电阻以免影响模拟部分功能
	PAPU = 0XFF;
	PBPU = 0XFF;	
	
	PAPD = 0XFF;
	PBPD = 0XFF;

	PAOD = 0X00;
	PBOD = 0X00;

	TRISA= 0X00;
	TRISB= 0X00;	
	
	PORTA= 0X00;	
	PORTB= 0X00;	
}

/*******************************************************************************
* Description    : TIMER2初始化设置
* Input          : 
* Return         : None.
* Note           : None.
*******************************************************************************/
void Timer2_Init(void)
{
	TMR2H  = 0x00;
	TMR2L  = 0x00; 	
	PR2H     = 0x06;        //PWM周期 = FOSC/[PR2H:PR2L]/Timer2预分频值/Timer2后分频值
	PR2L     = 0x40; 
	T2CON    = 0x04; 
	TMR2IF   = 0;
	TMR2IP   = 1;
	TMR2IE   = 0;
}


/*******************************************************************************
* Description    : CCP_PWM00-PWM21初始化
* Input          : None.
* Return         : None.
* Note           : PWM21_PB7、PWM20_PB6、PWM11_PA0、PWM10_PB0、PWM01_PB1、PWM00_PB2
*******************************************************************************/
void CCP_PWM_Init(void)
{
    PMS      = 0x00; 					//使能耳机防呆输出0，PWM14/PWM15、PWM12/PWM13、PWM10/PWM11三组互补式输出
    PXC      = 0x00; 					//PWM14映射至PB2
    DTC      = 0xAA; 					//死区时间配置为2.3us
    POLS     = 0x00; 					//同相输出
    PME      = 0x3F;                    //使能PWM21_PB7、PWM20_PB6、PWM11_PA0、PWM10_PB0、PWM01_PB1、PWM00_PB2输出
    PCS      = 0x0C;					//PWM21选择PB7输出 PWM20选择PB6输出  PWM11选择PA0输出  PWM10选择PB0输出
    CCPCON   = 0x02; 					//001X：PWM 模式，启动 CCP1 PWM 模式

}

/*******************************************************************************
* Description    : Timer2_PWM占空比设置
* Input          : Timer2_PWM的占空比 （0%-99%）
* Return         : None.
* Note           : 该函数可以设置Timer1_PWM的占空比
*                  *占空比=[PR2H:PR2L]*(Duty/100)
*******************************************************************************/
void Config_PWM_Duty(unsigned short Duty)
{   
   unsigned char PWMH = 0;
   unsigned char PWML = 0;
   
   Duty     = Duty-1;
   PWMH     = (Duty >> 8) & 0xFF;
   PWML     = Duty & 0xFF;

   CCPR1LH  = PWMH; 
   CCPR1L   = PWML;   //设置PWM占空比
}
